#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <syscall_thunk.h>
#include <errno.h>

static bitmask_transtbl	open_tbl[] = {
	{ X86_O_CREAT, X86_O_CREAT, O_CREAT, O_CREAT },
	{ X86_O_EXCL, X86_O_EXCL, O_EXCL, O_EXCL },
	{ X86_O_NOCTTY, X86_O_NOCTTY, O_NOCTTY, O_NOCTTY },
	{ X86_O_TRUNC, X86_O_TRUNC, O_TRUNC, O_TRUNC },
	{ X86_O_APPEND, X86_O_APPEND, O_APPEND, O_APPEND },
	{ X86_O_NONBLOCK, X86_O_NONBLOCK, O_NONBLOCK, O_NONBLOCK },
	{ X86_O_SYNC, X86_O_SYNC, O_SYNC, O_SYNC },
	{ 0, 0, 0, 0 }
};

extern unsigned int x86_to_alpha_bitmask(unsigned int, bitmask_transtbl *);
extern unsigned int alpha_to_x86_bitmask(unsigned int, bitmask_transtbl *);

int	do_open(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int retval;
    char *name = ARG_TO_POINTER(a0);
    int x86_flags = a1;
    int alpha_flags = 0;
    mode_t mode = a2;
    
    /* Massage the x86 flags into Alpha flags... */
    alpha_flags = x86_to_alpha_bitmask(x86_flags, open_tbl);

    /* ACCMODE flags are identical... */
    alpha_flags |= (x86_flags & O_ACCMODE);

    /* Modes should be the same... */
    retval = open(name, alpha_flags, mode);
    if(retval < 0) {
    	return(-alpha_to_intel_errno(errno));
    }
    else {
    	return(retval);
    }
    
}


