#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <syscall_thunk.h>
#include <errno.h>

extern int	x86_trace_current_syscall;

extern FILE *	x86_logfile;

/* The "old" version of select used a memory block to pass args
 * because the old system call paradigm couldn't take more than
 * four arguments...
 */
int	do_old_select(int a0, int a1, int a2, int a3, int a4, int a5)
{
    unsigned int *argp = ARG_TO_POINTER(a0);
    int n = argp[0];
    fd_set * readfds = ARG_TO_POINTER(argp[1]);
    fd_set * writefds = ARG_TO_POINTER(argp[2]);
    fd_set * exceptfds = ARG_TO_POINTER(argp[3]);
    struct timeval * timeout = ARG_TO_POINTER(argp[4]);
    int retval;

    if(x86_trace_current_syscall) {
	fprintf(x86_logfile, "...Calling select(%d, 0x%x, 0x%x, 0x%x, 0x%x)\r\n",
		n, readfds, writefds, exceptfds, timeout);
	fflush(x86_logfile);
    }
    retval = select(n, readfds, writefds, exceptfds, timeout);
    if(retval == -1) {
	return(-alpha_to_intel_errno(errno));
    }
    else {
	return(retval);
    }
}

